//
//  QSICommandProtected.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICommand.h"
#import "QSICommandId.h"

//
// Command buffer defines.
//
#define QSICommandBufferMaxSize                 128
#define QSICommandBufferCommandByteOffset       0
#define QSICommandBufferCommandByteLength       1
#define QSICommandBufferCommandLengthByteOffset (QSICommandBufferCommandByteOffset + QSICommandBufferCommandByteLength)
#define QSICommandBufferCommandLengthByteLength  1
#define QSICommandBufferHeaderSize              (QSICommandBufferCommandLengthByteOffset + QSICommandBufferCommandLengthByteLength)

#define QSIResponseBufferMaxSize                128
#define QSIResponseBufferErrorByteLength        1
#define QSIResponseBufferHeaderSize             QSICommandBufferHeaderSize

typedef struct __attribute__((packed)) _QSICommandBufferHeader
{
  uint8_t _command;
  uint8_t _commandLength;
} QSICommandBufferHeader;

typedef struct __attribute__((packed)) _QSICommandBuffer
{
  QSICommandBufferHeader  _header;
} QSICommandBuffer;

typedef QSICommandBufferHeader  QSIResponseBufferHeader;

typedef struct __attribute__((packed)) _QSIResponseBufferTrailer
{
  uint8_t _error;
} QSIResponseBufferTrailer;

typedef struct __attribute__((packed)) _QSIResponseBuffer
{
  QSIResponseBufferHeader   _header;
  QSIResponseBufferTrailer  _trailer;
} QSIResponseBuffer;

@interface QSICommand (QSICommandProtectedClassMethods)
@end // @interface QSICommand (QSICommandProtectedClassMethods)

@interface QSICommand (QSICommandProtectedInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
         andCommandId : (QSICommandId)  aCommandId;

- (id) initUsingComms : (QSIComms *) aCommsObject
            commandId : (QSICommandId)  aCommandId
 andCommandBufferSize : (uint8_t) aCommandBufferSize;

- (id) initUsingComms : (QSIComms *) aCommsObject
            commandId : (QSICommandId)  aCommandId
andResponseBufferSize : (uint8_t) aResponseBufferSize;

- (id) initUsingComms : (QSIComms *) aCommsObject
            commandId : (QSICommandId)  aCommandId
    commandBufferSize : (uint8_t) aCommandBufferSize
andResponseBufferSize : (uint8_t) aResponseBufferSize;

- (char *) commandBuffer;
- (QSICommandId) commandId;
- (char *) responseBuffer;

- (void) preprocessCommandBuffer;
- (void) postprocessResponseBuffer;

- (QSIEndian *) endianTranslator;
@end // @interface QSICommand (QSICommandProtectedInstanceMethods)
