//
//  QSIGetAdvancedDetails.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetAdvancedDetailsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetAdvancedDetails Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAdvancedDetails Private Class Methods
//
@interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateClassMethods)
@end // @interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateClassMethods)

@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateClassMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateClassMethods)

//
// QSIGetAdvancedDetails Private Instance Methods
//
@interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateInstanceMethods)
@end // @interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateInstanceMethods)

@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateInstanceMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetAdvancedDetails Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAdvancedDetails Infrastructure Class Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsInfrastructureClassMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsInfrastructureClassMethods)

//
// QSIGetAdvancedDetails Infrastructure Instance Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsInfrastructureInstanceMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetAdvancedDetails Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAdvancedDetails Overridden Class Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsOverriddenClassMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsOverriddenClassMethods)

//
// QSIGetAdvancedDetails Overridden Instance Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsOverriddenInstanceMethods)
- (void) dealloc
{
  [_filters release];
  [_results release];

  [super dealloc];
} // end -dealloc

- (QSIStatus) execute
{
  QSIStatus status  = QSISuccess;

  status = [super execute];
  if (status == QSISuccess)
  {
    uint8_t filterIndex;
    for (filterIndex = 0; filterIndex < QSIMaxFilterCount; filterIndex ++)
    {
      NSString  *filterName = [NSString stringWithFormat:@"Filter %d", filterIndex + 1];

      if (filterName == nil)
      {
        status = QSIAllocationFailed;
        break;
      }

      QSIFilter *filter = [[[QSIFilter alloc] initWithName:filterName
                                            andFocusOffset:0] autorelease];
      if (filter == nil)
      {
        status = QSIAllocationFailed;
        break;
      }

      [_filters addObject:filter];
    }
  }

  return (status);
} // end -execute

- (void) postprocessResponseBuffer
{
  QSIGetAdvancedDetailsResponseBuffer  *responseBuffer = (QSIGetAdvancedDetailsResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _results._antiBloomingEnabled          = [translator getBoolFromSource:&responseBuffer->_antibloomingEnabled];
  _results._antiBloomingIndex            = responseBuffer->_antibloomingDefault;

  _results._cameraGainEnabled            = [translator getBoolFromSource:&responseBuffer->_cameraGainEnabled];
  _results._cameraGainIndex              = responseBuffer->_cameraGainDefault;

  _results._fanModeEnabled               = [translator getBoolFromSource:&responseBuffer->_fanModeEnabled];
  _results._fanModeIndex                 = responseBuffer->_fanModeDefault;

  _results._ledIndicatorDefault          = [translator getBoolFromSource:&responseBuffer->_ledIndicatorDefault];
  _results._ledIndicatorEnabled          = [translator getBoolFromSource:&responseBuffer->_ledIndicatorEnabled];

  _results._optimizationsEnabled         = [translator getBoolFromSource:&responseBuffer->_optimizationsEnabled];
  _results._optimizeReadoutSpeed         = [translator getBoolFromSource:&responseBuffer->_optimizeReadoutDefault];

  _results._preExposureFlushEnabled      = [translator getBoolFromSource:&responseBuffer->_preExposureFlushEnabled];
  _results._preExposureFlushIndex        = responseBuffer->_preExposureFlushDefault;

  _results._showDownloadProgressDefault  = [translator getBoolFromSource:&responseBuffer->_showDownloadProgressDefault];
  _results._showDownloadProgressEnabled  = [translator getBoolFromSource:&responseBuffer->_showDownloadProgressEnabled];

  _results._shutterPriorityEnabled       = [translator getBoolFromSource:&responseBuffer->_shutterPriorityEnabled];
  _results._shutterPriorityIndex         = responseBuffer->_shutterPriorityDefault;

  _results._soundOnDefault               = [translator getBoolFromSource:&responseBuffer->_soundOnDefault];
  _results._soundOnEnabled               = [translator getBoolFromSource:&responseBuffer->_soundOnEnabled];
} // end -postprocessResponseBuffer
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetAdvancedDetails Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAdvancedDetails Public Class Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPublicClassMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPublicClassMethods)

//
// QSIGetAdvancedDetails Public Instance Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
   andAdvancedDetails : (QSICameraAdvancedDetails *) aResults
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIGetAdvancedDetailsCommand
         andResponseBufferSize:sizeof(QSIGetAdvancedDetailsResponseBuffer)];

  if (self != nil)
  {
    _filters = [[NSMutableArray alloc] init];

    if (_filters == nil)
    {
      [self release];
      self = nil;
    }
  }
  
  if (self != nil)
  {
    _results = [aResults retain];
  }

  return (self);
} // end -initUsingComms:

- (NSArray *) filters
{
  return (_filters);
} // end -filters
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetAdvancedDetails Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAdvancedDetails Protected Class Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedClassMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedClassMethods)

//
// QSIGetAdvancedDetails Protected Instance Methods
//
@implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedInstanceMethods)
@end // @implementation QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetAdvancedDetails
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetAdvancedDetails
@end // @implementation QSIGetAdvancedDetails
