//
//  QSIGetAdvancedDetailsProtected.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICommandProtected.h"
#import "QSIGetAdvancedDetails.h"

#define QSIGetAdvancedDetailsCommand  ((QSICommandId) 0x4c)

typedef struct __attribute__((packed)) _QSIGetAdvancedDetailsResponseBuffer
{
  QSIResponseBufferHeader   _header;

  uint8_t _ledIndicatorEnabled;
  uint8_t _ledIndicatorDefault;
  uint8_t _soundOnEnabled;
  uint8_t _soundOnDefault;
  uint8_t _fanModeEnabled;
  uint8_t _fanModeDefault;
  uint8_t _cameraGainEnabled;
  uint8_t _cameraGainDefault;
  uint8_t _shutterPriorityEnabled;
  uint8_t _shutterPriorityDefault;
  uint8_t _antibloomingEnabled;
  uint8_t _antibloomingDefault;
  uint8_t _preExposureFlushEnabled;
  uint8_t _preExposureFlushDefault;
  uint8_t _showDownloadProgressEnabled;
  uint8_t _showDownloadProgressDefault;
  uint8_t _optimizationsEnabled;
  uint8_t _optimizeReadoutDefault;

  QSIResponseBufferTrailer  _trailer;
} QSIGetAdvancedDetailsResponseBuffer;

@interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedClassMethods)
@end // @interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedClassMethods)

@interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedInstanceMethods)
@end // @interface QSIGetAdvancedDetails (QSIGetAdvancedDetailsProtectedInstanceMethods)
