//
//  QSIGetAltMode1.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetAltMode1Protected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetAltMode1 Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAltMode1 Private Class Methods
//
@interface QSIGetAltMode1 (QSIGetAltMode1PrivateClassMethods)
@end // @interface QSIGetAltMode1 (QSIGetAltMode1PrivateClassMethods)

@implementation QSIGetAltMode1 (QSIGetAltMode1PrivateClassMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1PrivateClassMethods)

//
// QSIGetAltMode1 Private Instance Methods
//
@interface QSIGetAltMode1 (QSIGetAltMode1PrivateInstanceMethods)
@end // @interface QSIGetAltMode1 (QSIGetAltMode1PrivateInstanceMethods)

@implementation QSIGetAltMode1 (QSIGetAltMode1PrivateInstanceMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1PrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetAltMode1 Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAltMode1 Infrastructure Class Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1InfrastructureClassMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1InfrastructureClassMethods)

//
// QSIGetAltMode1 Infrastructure Instance Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1InfrastructureInstanceMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1InfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetAltMode1 Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAltMode1 Overridden Class Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1OverriddenClassMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1OverriddenClassMethods)

//
// QSIGetAltMode1 Overridden Instance Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1OverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSIGetAltMode1ResponseBuffer  *responseBuffer = (QSIGetAltMode1ResponseBuffer *) [self responseBuffer];

  _altMode1 = responseBuffer->_altMode1;
} // end -postprocessResponseBuffer
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1OverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetAltMode1 Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAltMode1 Public Class Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1PublicClassMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1PublicClassMethods)

//
// QSIGetAltMode1 Public Instance Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1PublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
{
  return ([super initUsingComms:aCommsObject
                      commandId:QSIGetAltMode1Command
          andResponseBufferSize:sizeof(QSIGetAltMode1ResponseBuffer)]);
} // end -initUsingComms:

- (uint8_t) altMode1
{
  return (_altMode1);
} // end -altMode1
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1PublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetAltMode1 Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetAltMode1 Protected Class Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1ProtectedClassMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1ProtectedClassMethods)

//
// QSIGetAltMode1 Protected Instance Methods
//
@implementation QSIGetAltMode1 (QSIGetAltMode1ProtectedInstanceMethods)
@end // @implementation QSIGetAltMode1 (QSIGetAltMode1ProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetAltMode1
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetAltMode1
@end // @implementation QSIGetAltMode1
