//
//  QSIGetCCDSpecs.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetCCDSpecsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetCCDSpecs Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetCCDSpecs Private Class Methods
//
@interface QSIGetCCDSpecs (QSIGetCCDSpecsPrivateClassMethods)
@end // @interface QSIGetCCDSpecs (QSIGetCCDSpecsPrivateClassMethods)

@implementation QSIGetCCDSpecs (QSIGetCCDSpecsPrivateClassMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsPrivateClassMethods)

//
// QSIGetCCDSpecs Private Instance Methods
//
@interface QSIGetCCDSpecs (QSIGetCCDSpecsPrivateInstanceMethods)
@end // @interface QSIGetCCDSpecs (QSIGetCCDSpecsPrivateInstanceMethods)

@implementation QSIGetCCDSpecs (QSIGetCCDSpecsPrivateInstanceMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetCCDSpecs Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetCCDSpecs Infrastructure Class Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsInfrastructureClassMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsInfrastructureClassMethods)

//
// QSIGetCCDSpecs Infrastructure Instance Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsInfrastructureInstanceMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetCCDSpecs Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetCCDSpecs Overridden Class Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsOverriddenClassMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsOverriddenClassMethods)

//
// QSIGetCCDSpecs Overridden Instance Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsOverriddenInstanceMethods)
- (void) dealloc
{
  [_results release];
  
  [super dealloc];
} // end -dealloc

- (void) postprocessResponseBuffer
{
  QSIGetCCDSpecsResponseBuffer  *responseBuffer = (QSIGetCCDSpecsResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _results._maxADU              = [translator get16BitsFromSource:&responseBuffer->_maxADU];
  _results._electronsPerADUHigh = [translator get16BitsFromSource:&responseBuffer->_electronsPerADU] / 1000.0;
  _results._electronsPerADULow  = _results._electronsPerADUHigh;
  _results._fullWell            = [translator get16BitsFromSource:&responseBuffer->_fullWell] * 100.0;

  // Camera returns minimum exposure in 100 usecond units.
  _results._minExposure         = [translator get16BitsFromSource:&responseBuffer->_minExposure] / 10000.0;

  // Camera returns maximum exposure in 1 second units.
  _results._maxExposure         = [translator get16BitsFromSource:&responseBuffer->_maxExposure];
} // end -postprocessResponseBuffer
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetCCDSpecs Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetCCDSpecs Public Class Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsPublicClassMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsPublicClassMethods)

//
// QSIGetCCDSpecs Public Instance Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
           forResults : (QSICameraCCDSpecs *) aResults
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIGetCCDSpecsCommand
         andResponseBufferSize:sizeof(QSIGetCCDSpecsResponseBuffer)];
  if (self != nil)
  {
    _results = [aResults retain];
  }

  return (self);
} // end -initUsingComms:
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetCCDSpecs Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetCCDSpecs Protected Class Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsProtectedClassMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsProtectedClassMethods)

//
// QSIGetCCDSpecs Protected Instance Methods
//
@implementation QSIGetCCDSpecs (QSIGetCCDSpecsProtectedInstanceMethods)
@end // @implementation QSIGetCCDSpecs (QSIGetCCDSpecsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetCCDSpecs
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetCCDSpecs
@end // @implementation QSIGetCCDSpecs
