//
//  QSIGetDetails.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetDetailsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetDetails Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDetails Private Class Methods
//
@interface QSIGetDetails (QSIGetDetailsPrivateClassMethods)
@end // @interface QSIGetDetails (QSIGetDetailsPrivateClassMethods)

@implementation QSIGetDetails (QSIGetDetailsPrivateClassMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsPrivateClassMethods)

//
// QSIGetDetails Private Instance Methods
//
@interface QSIGetDetails (QSIGetDetailsPrivateInstanceMethods)
@end // @interface QSIGetDetails (QSIGetDetailsPrivateInstanceMethods)

@implementation QSIGetDetails (QSIGetDetailsPrivateInstanceMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetDetails Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDetails Infrastructure Class Methods
//
@implementation QSIGetDetails (QSIGetDetailsInfrastructureClassMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsInfrastructureClassMethods)

//
// QSIGetDetails Infrastructure Instance Methods
//
@implementation QSIGetDetails (QSIGetDetailsInfrastructureInstanceMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetDetails Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDetails Overridden Class Methods
//
@implementation QSIGetDetails (QSIGetDetailsOverriddenClassMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsOverriddenClassMethods)

//
// QSIGetDetails Overridden Instance Methods
//
@implementation QSIGetDetails (QSIGetDetailsOverriddenInstanceMethods)
- (void) dealloc
{
  [_results release];
  
  [super dealloc];
} // end -dealloc

- (void) postprocessResponseBuffer
{
  QSIGetDetailsResponseBuffer  *responseBuffer = (QSIGetDetailsResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _results._arrayColumns                = [translator get16BitsFromSource:&responseBuffer->_arrayColumns];
  _results._arrayRows                   = [translator get16BitsFromSource:&responseBuffer->_arrayRows];

  _results._hasCamera                   = [translator getBoolFromSource:&responseBuffer->_hasCamera];
  _results._hasFilterWheel              = [translator getBoolFromSource:&responseBuffer->_hasFilterWheel];
  _results._hasRelays                   = [translator getBoolFromSource:&responseBuffer->_hasRelays];
  _results._hasShutter                  = [translator getBoolFromSource:&responseBuffer->_hasShutter];
  _results._hasTemperatureRegulator     = [translator getBoolFromSource:&responseBuffer->_hasTemperatureRegulator];
  _results._maxHorizontalBinning        = responseBuffer->_maxHorizontalBinning;
  _results._maxVerticalBinning          = responseBuffer->_maxVerticalBinning;
  _results._modelName                   = [[[NSString alloc] initWithBytes:responseBuffer->_modelName
                                                                    length:QSIMaxModelNameLength
                                                                  encoding:NSASCIIStringEncoding] autorelease];
  _results._modelNumber                 = [[[NSString alloc] initWithBytes:responseBuffer->_modelNumber
                                                                    length:QSIMaxModelNumberLength
                                                                  encoding:NSASCIIStringEncoding] autorelease];
  _results._numberOfFilters             = responseBuffer->_numberOfFilters;
  _results._numberOfRowsPerBlock        = [translator get16BitsFromSource:&responseBuffer->_numberOfRowsPerBlock];
  _results._perBlockControl             = [translator getBoolFromSource:&responseBuffer->_perBlockControl];
  _results._powerOfTwoBinning           = [translator getBoolFromSource:&responseBuffer->_powerOfTwoBinning];
  _results._serialNumber                = [[[NSString alloc] initWithBytes:responseBuffer->_serialNumber
                                                                    length:QSIMaxSerialNumberLength
                                                                  encoding:NSASCIIStringEncoding] autorelease];
  _results._supportsAsymmetricBinning   = [translator getBoolFromSource:&responseBuffer->_supportsAsymmetricBinning];
  _results._pixelWidth                  = [translator get16BitsFromSource:&responseBuffer->_xAspect];
  _results._pixelHeight                 = [translator get16BitsFromSource:&responseBuffer->_yAspect];
} // end -postprocessResponseBuffer
@end // @implementation QSIGetDetails (QSIGetDetailsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetDetails Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDetails Public Class Methods
//
@implementation QSIGetDetails (QSIGetDetailsPublicClassMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsPublicClassMethods)

//
// QSIGetDetails Public Instance Methods
//
@implementation QSIGetDetails (QSIGetDetailsPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
    andDetailsResults : (QSICameraDetails *) aResults
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIGetDetailsCommand
         andResponseBufferSize:sizeof(QSIGetDetailsResponseBuffer)];
  if (self != nil)
  {
    _results = [aResults retain];
  }

  return (self);
} // end -initUsingComms:andDetailsResults:
@end // @implementation QSIGetDetails (QSIGetDetailsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetDetails Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDetails Protected Class Methods
//
@implementation QSIGetDetails (QSIGetDetailsProtectedClassMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsProtectedClassMethods)

//
// QSIGetDetails Protected Instance Methods
//
@implementation QSIGetDetails (QSIGetDetailsProtectedInstanceMethods)
@end // @implementation QSIGetDetails (QSIGetDetailsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetDetails
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetDetails
@end // @implementation QSIGetDetails
