//
//  QSIGetDetailsProtected.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICommandProtected.h"
#import "QSIGetDetails.h"

#define QSIGetDetailsCommand  ((QSICommandId) 0x41)

typedef struct __attribute__((packed)) _QSIGetDetailsResponseBuffer
{
  QSIResponseBufferHeader   _header;

  uint8_t   _hasCamera;
  uint8_t   _hasShutter;
  uint8_t   _hasFilterWheel;
  uint8_t   _hasRelays;
  uint8_t   _hasTemperatureRegulator;
  uint16_t  _arrayColumns;
  uint16_t  _arrayRows;
  uint16_t  _xAspect;
  uint16_t  _yAspect;
  uint8_t   _maxHorizontalBinning;
  uint8_t   _maxVerticalBinning;
  uint8_t   _supportsAsymmetricBinning;
  uint8_t   _powerOfTwoBinning;
  uint16_t  _numberOfRowsPerBlock;
  uint8_t   _perBlockControl;
  uint8_t   _numberOfFilters;
  uint8_t   _modelNumber[QSIMaxModelNumberLength];
  uint8_t   _modelName[QSIMaxModelNameLength];
  uint8_t   _serialNumber[QSIMaxSerialNumberLength];

  QSIResponseBufferTrailer  _trailer;
} QSIGetDetailsResponseBuffer;

@interface QSIGetDetails (QSIGetDetailsProtectedClassMethods)
@end // @interface QSIGetDetails (QSIGetDetailsProtectedClassMethods)

@interface QSIGetDetails (QSIGetDetailsProtectedInstanceMethods)
@end // @interface QSIGetDetails (QSIGetDetailsProtectedInstanceMethods)
