//
//  QSIGetDeviceState.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetDeviceStateProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetDeviceState Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDeviceState Private Class Methods
//
@interface QSIGetDeviceState (QSIGetDeviceStatePrivateClassMethods)
@end // @interface QSIGetDeviceState (QSIGetDeviceStatePrivateClassMethods)

@implementation QSIGetDeviceState (QSIGetDeviceStatePrivateClassMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStatePrivateClassMethods)

//
// QSIGetDeviceState Private Instance Methods
//
@interface QSIGetDeviceState (QSIGetDeviceStatePrivateInstanceMethods)
@end // @interface QSIGetDeviceState (QSIGetDeviceStatePrivateInstanceMethods)

@implementation QSIGetDeviceState (QSIGetDeviceStatePrivateInstanceMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStatePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetDeviceState Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDeviceState Infrastructure Class Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStateInfrastructureClassMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStateInfrastructureClassMethods)

//
// QSIGetDeviceState Infrastructure Instance Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStateInfrastructureInstanceMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStateInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetDeviceState Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDeviceState Overridden Class Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStateOverriddenClassMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStateOverriddenClassMethods)

//
// QSIGetDeviceState Overridden Instance Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStateOverriddenInstanceMethods)
- (uint8_t) attemptLimit
{
  return (3);
} // end -attemptLimit

- (void) postprocessResponseBuffer
{
  QSIGetDeviceStateResponseBuffer  *responseBuffer = (QSIGetDeviceStateResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _results._cameraState  = responseBuffer->_cameraState;
  _results._filterState  = [translator getBoolFromSource:&responseBuffer->_filterState];
  _results._shutterOpen  = [translator getBoolFromSource:&responseBuffer->_shutterState];
} // end -postprocessResponseBuffer
@end // @implementation QSIGetDeviceState (QSIGetDeviceStateOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetDeviceState Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDeviceState Public Class Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStatePublicClassMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStatePublicClassMethods)

//
// QSIGetDeviceState Public Instance Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStatePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
      andStateResults : (QSICameraDeviceState *) aResults
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSIGetDeviceStateCommand
         andResponseBufferSize:sizeof(QSIGetDeviceStateResponseBuffer)];
  if (self != nil)
  {
    _results = aResults;
  }

  return (self);
} // end -initUsingComms:andStateResults:
@end // @implementation QSIGetDeviceState (QSIGetDeviceStatePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetDeviceState Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetDeviceState Protected Class Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStateProtectedClassMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStateProtectedClassMethods)

//
// QSIGetDeviceState Protected Instance Methods
//
@implementation QSIGetDeviceState (QSIGetDeviceStateProtectedInstanceMethods)
@end // @implementation QSIGetDeviceState (QSIGetDeviceStateProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetDeviceState
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetDeviceState
@end // @implementation QSIGetDeviceState
