//
//  QSIGetFilterPosition.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetFilterPositionProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetFilterPosition Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetFilterPosition Private Class Methods
//
@interface QSIGetFilterPosition (QSIGetFilterPositionPrivateClassMethods)
@end // @interface QSIGetFilterPosition (QSIGetFilterPositionPrivateClassMethods)

@implementation QSIGetFilterPosition (QSIGetFilterPositionPrivateClassMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionPrivateClassMethods)

//
// QSIGetFilterPosition Private Instance Methods
//
@interface QSIGetFilterPosition (QSIGetFilterPositionPrivateInstanceMethods)
@end // @interface QSIGetFilterPosition (QSIGetFilterPositionPrivateInstanceMethods)

@implementation QSIGetFilterPosition (QSIGetFilterPositionPrivateInstanceMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetFilterPosition Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetFilterPosition Infrastructure Class Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionInfrastructureClassMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionInfrastructureClassMethods)

//
// QSIGetFilterPosition Infrastructure Instance Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionInfrastructureInstanceMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetFilterPosition Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetFilterPosition Overridden Class Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionOverriddenClassMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionOverriddenClassMethods)

//
// QSIGetFilterPosition Overridden Instance Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionOverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSIGetFilterPositionResponseBuffer  *responseBuffer = (QSIGetFilterPositionResponseBuffer *) [self responseBuffer];

  // Response is filter index; we need to return filter position.
  _filterPosition = responseBuffer->_filterIndex + 1;
} // end -postprocessResponseBuffer
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetFilterPosition Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetFilterPosition Public Class Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionPublicClassMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionPublicClassMethods)

//
// QSIGetFilterPosition Public Instance Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
{
  return ([super initUsingComms:aCommsObject
                      commandId:QSIGetFilterPositionCommand
          andResponseBufferSize:sizeof(QSIGetFilterPositionResponseBuffer)]);
} // end -initUsingComms:

- (uint8_t) filterPosition
{
  return (_filterPosition);
} // end -filterPosition
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetFilterPosition Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetFilterPosition Protected Class Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionProtectedClassMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionProtectedClassMethods)

//
// QSIGetFilterPosition Protected Instance Methods
//
@implementation QSIGetFilterPosition (QSIGetFilterPositionProtectedInstanceMethods)
@end // @implementation QSIGetFilterPosition (QSIGetFilterPositionProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetFilterPosition
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetFilterPosition
@end // @implementation QSIGetFilterPosition
