//
//  QSIGetLastExposure.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetLastExposureProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetLastExposure Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetLastExposure Private Class Methods
//
@interface QSIGetLastExposure (QSIGetLastExposurePrivateClassMethods)
@end // @interface QSIGetLastExposure (QSIGetLastExposurePrivateClassMethods)

@implementation QSIGetLastExposure (QSIGetLastExposurePrivateClassMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposurePrivateClassMethods)

//
// QSIGetLastExposure Private Instance Methods
//
@interface QSIGetLastExposure (QSIGetLastExposurePrivateInstanceMethods)
@end // @interface QSIGetLastExposure (QSIGetLastExposurePrivateInstanceMethods)

@implementation QSIGetLastExposure (QSIGetLastExposurePrivateInstanceMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposurePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetLastExposure Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetLastExposure Infrastructure Class Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposureInfrastructureClassMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposureInfrastructureClassMethods)

//
// QSIGetLastExposure Infrastructure Instance Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposureInfrastructureInstanceMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposureInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetLastExposure Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetLastExposure Overridden Class Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposureOverriddenClassMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposureOverriddenClassMethods)

//
// QSIGetLastExposure Overridden Instance Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposureOverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSIGetLastExposureResponseBuffer  *responseBuffer = (QSIGetLastExposureResponseBuffer *) [self responseBuffer];

  uint8_t index;
  for (index = 0; index < (sizeof(responseBuffer->_exposure) / sizeof(responseBuffer->_exposure[0])); index ++)
  {
    if (responseBuffer->_exposure[index] != 0xff)
    {
      break;
    }
  }

  if (index < (sizeof(responseBuffer->_exposure) / sizeof(responseBuffer->_exposure[0])))
  {
    QSIEndian *translator = [self endianTranslator];

    _exposure = [translator get24BitsFromSource:responseBuffer->_exposure] / 100.0;
  }
  else
  {
    _exposure = -1;
  }
} // end -postprocessResponseBuffer
@end // @implementation QSIGetLastExposure (QSIGetLastExposureOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetLastExposure Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetLastExposure Public Class Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposurePublicClassMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposurePublicClassMethods)

//
// QSIGetLastExposure Public Instance Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposurePublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
{
  return ([super initUsingComms:aCommsObject
                      commandId:QSIGetLastExposureCommand
          andResponseBufferSize:sizeof(QSIGetLastExposureResponseBuffer)]);
} // end -initUsingComms:

- (double) exposure
{
  return (_exposure);
} // end -exposure
@end // @implementation QSIGetLastExposure (QSIGetLastExposurePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetLastExposure Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetLastExposure Protected Class Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposureProtectedClassMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposureProtectedClassMethods)

//
// QSIGetLastExposure Protected Instance Methods
//
@implementation QSIGetLastExposure (QSIGetLastExposureProtectedInstanceMethods)
@end // @implementation QSIGetLastExposure (QSIGetLastExposureProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetLastExposure
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetLastExposure
@end // @implementation QSIGetLastExposure
