//
//  QSIGetSetPoint.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIGetSetPointProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIGetSetPoint Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetSetPoint Private Class Methods
//
@interface QSIGetSetPoint (QSIGetSetPointPrivateClassMethods)
@end // @interface QSIGetSetPoint (QSIGetSetPointPrivateClassMethods)

@implementation QSIGetSetPoint (QSIGetSetPointPrivateClassMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointPrivateClassMethods)

//
// QSIGetSetPoint Private Instance Methods
//
@interface QSIGetSetPoint (QSIGetSetPointPrivateInstanceMethods)
@end // @interface QSIGetSetPoint (QSIGetSetPointPrivateInstanceMethods)

@implementation QSIGetSetPoint (QSIGetSetPointPrivateInstanceMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetSetPoint Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetSetPoint Infrastructure Class Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointInfrastructureClassMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointInfrastructureClassMethods)

//
// QSIGetSetPoint Infrastructure Instance Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointInfrastructureInstanceMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetSetPoint Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetSetPoint Overridden Class Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointOverriddenClassMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointOverriddenClassMethods)

//
// QSIGetSetPoint Overridden Instance Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointOverriddenInstanceMethods)
- (void) postprocessResponseBuffer
{
  QSIGetSetPointResponseBuffer  *responseBuffer = (QSIGetSetPointResponseBuffer *) [self responseBuffer];

  QSIEndian *translator = [self endianTranslator];

  _setPoint = ((int16_t) [translator get16BitsFromSource:&responseBuffer->_setPoint]) / 100.0;
} // end -postprocessResponseBuffer
@end // @implementation QSIGetSetPoint (QSIGetSetPointOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIGetSetPoint Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetSetPoint Public Class Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointPublicClassMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointPublicClassMethods)

//
// QSIGetSetPoint Public Instance Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
{
  return ([super initUsingComms:aCommsObject
                      commandId:QSIGetSetPointCommand
          andResponseBufferSize:sizeof(QSIGetSetPointResponseBuffer)]);
} // end -initUsingComms:

- (double) setPoint
{
  return (_setPoint);
} // end -setPoint
@end // @implementation QSIGetSetPoint (QSIGetSetPointPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIGetSetPoint Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIGetSetPoint Protected Class Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointProtectedClassMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointProtectedClassMethods)

//
// QSIGetSetPoint Protected Instance Methods
//
@implementation QSIGetSetPoint (QSIGetSetPointProtectedInstanceMethods)
@end // @implementation QSIGetSetPoint (QSIGetSetPointProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIGetSetPoint
************************************************************************************************
***********************************************************************************************/

@implementation QSIGetSetPoint
@end // @implementation QSIGetSetPoint
