//
//  QSISetShutter.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSISetShutterProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSISetShutter Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetShutter Private Class Methods
//
@interface QSISetShutter (QSISetShutterPrivateClassMethods)
@end // @interface QSISetShutter (QSISetShutterPrivateClassMethods)

@implementation QSISetShutter (QSISetShutterPrivateClassMethods)
@end // @implementation QSISetShutter (QSISetShutterPrivateClassMethods)

//
// QSISetShutter Private Instance Methods
//
@interface QSISetShutter (QSISetShutterPrivateInstanceMethods)
@end // @interface QSISetShutter (QSISetShutterPrivateInstanceMethods)

@implementation QSISetShutter (QSISetShutterPrivateInstanceMethods)
@end // @implementation QSISetShutter (QSISetShutterPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSISetShutter Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetShutter Infrastructure Class Methods
//
@implementation QSISetShutter (QSISetShutterInfrastructureClassMethods)
@end // @implementation QSISetShutter (QSISetShutterInfrastructureClassMethods)

//
// QSISetShutter Infrastructure Instance Methods
//
@implementation QSISetShutter (QSISetShutterInfrastructureInstanceMethods)
@end // @implementation QSISetShutter (QSISetShutterInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetShutter Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetShutter Overridden Class Methods
//
@implementation QSISetShutter (QSISetShutterOverriddenClassMethods)
@end // @implementation QSISetShutter (QSISetShutterOverriddenClassMethods)

//
// QSISetShutter Overridden Instance Methods
//
@implementation QSISetShutter (QSISetShutterOverriddenInstanceMethods)
- (void) preprocessCommandBuffer
{
  QSISetShutterCommandBuffer  *commandBuffer = (QSISetShutterCommandBuffer *) [self commandBuffer];

  QSIEndian *translator = [self endianTranslator];

  [translator setBool:&commandBuffer->_shutterOpen fromValue:_shutterOpen];
} // end -preprocessCommandBuffer
@end // @implementation QSISetShutter (QSISetShutterOverriddenInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetShutter Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetShutter Public Class Methods
//
@implementation QSISetShutter (QSISetShutterPublicClassMethods)
@end // @implementation QSISetShutter (QSISetShutterPublicClassMethods)

//
// QSISetShutter Public Instance Methods
//
@implementation QSISetShutter (QSISetShutterPublicInstanceMethods)
- (id) initUsingComms : (QSIComms *) aCommsObject
       andShutterOpen : (bool) aShutterOpen
{
  self = [super initUsingComms:aCommsObject
                     commandId:QSISetShutterCommand
          andCommandBufferSize:sizeof(QSISetShutterCommandBuffer)];
  if (self != nil)
  {
    _shutterOpen = aShutterOpen;
  }

  return (self);
} // end -initUsingComms:andShutterOpen:
@end // @implementation QSISetShutter (QSISetShutterPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSISetShutter Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSISetShutter Protected Class Methods
//
@implementation QSISetShutter (QSISetShutterProtectedClassMethods)
@end // @implementation QSISetShutter (QSISetShutterProtectedClassMethods)

//
// QSISetShutter Protected Instance Methods
//
@implementation QSISetShutter (QSISetShutterProtectedInstanceMethods)
@end // @implementation QSISetShutter (QSISetShutterProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSISetShutter
************************************************************************************************
***********************************************************************************************/

@implementation QSISetShutter
@end // @implementation QSISetShutter
