//
//  QSICommon.h
//  QSICamera
//
//  Generic Common Types
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import <Cocoa/Cocoa.h>

#define no  NO
#define yes YES

#define QSIMaxFilterCount         8
#define QSIMaxModelNameLength     32
#define QSIMaxModelNumberLength   32
#define QSIMaxSerialNumberLength  16

#define QSIMinMaxPixelsPerBlock   1000

#define QSIDefaultAutoZeroEnabled             yes
#define QSIDefaultAutoZeroMaxADU              64000
#define QSIDefaultAutoZeroMedian              no
#define QSIDefaultAutoZeroSaturationThreshold 2000
#define QSIDefaultAutoZeroSkipEndPixels       32
#define QSIDefaultAutoZeroSkipStartPixels     32
#define QSIDefaultMaxPixelsPerBlock           QSIMinMaxPixelsPerBlock
#define QSIAutoZeroSaturatedPixel             65535

#define QSIDefaultColorProfiling  no
#define QSIDefaultTestBayerImage  no

#define QSILog(_formatString, ...)  \
do                                                                            \
{                                                                             \
  QSILogMessage(@"[%@:(%d)], " _formatString,                                 \
                [[NSString stringWithUTF8String:__FILE__] lastPathComponent], \
                __LINE__,                                                     \
                ##__VA_ARGS__);                                               \
} while (false)

#define QSIStatusLog(_status, _formatString, ...) \
do                                                                            \
{                                                                             \
  QSILogMessage(@"[%@:(%d)], status = %@, " _formatString,                    \
                [[NSString stringWithUTF8String:__FILE__] lastPathComponent], \
                __LINE__,                                                     \
                qsiStatusText(_status),                                       \
                ##__VA_ARGS__);                                               \
} while (false)

#if defined(DEBUG_QSICamera)
  #define QSIDebugLog(_formatString, ...)                 QSILog(_formatString, ##__VA_ARGS__)
  #define QSIDebugStatusLog(_status, _formatString, ...)  QSIStatusLog(_status, _formatString, ##__VA_ARGS__)
#else
  #define QSIDebugLog(_formatString, ...)
  #define QSIDebugStatusLog(_status, _formatString, ...)
#endif // defined(DEBUG_QSICamera)

typedef enum _QSIStatus
{
  QSISuccess  = 0x00000000,
  QSIFailure, // Generic failure

  // Specific errors
  QSIAbortedExposure,
  QSIAllocationFailed,
  QSICloseFailed,
  QSICommandFailed,
  QSIConnected,
  QSIControlFailed,
  QSIInvalidParameter,
  QSINoExposure,
  QSINoFilter,
  QSINoImage,
  QSINoMemory,
  QSINotConnected,
  QSINotSupported,
  QSIOpenFailed,
  QSIReadFailed,
  QSIWriteFailed
} QSIStatus;

extern
NSString *
qsiStatusText(QSIStatus aStatus);

typedef void  (*QSILoggingMethod)(NSString *aFormatString, ...);

extern
QSILoggingMethod
QSISetLoggingMethod(QSILoggingMethod aLoggingMethod);

extern
void
QSILogMessage(NSString *aFormatString, ...);
