//
//  QSIEndian.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIEndianProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIEndian Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIEndian Private Class Methods
//
@interface QSIEndian (QSIEndianPrivateClassMethods)
@end // @interface QSIEndian (QSIEndianPrivateClassMethods)

@implementation QSIEndian (QSIEndianPrivateClassMethods)
@end // @implementation QSIEndian (QSIEndianPrivateClassMethods)

//
// QSIEndian Private Instance Methods
//
@interface QSIEndian (QSIEndianPrivateInstanceMethods)
@end // @interface QSIEndian (QSIEndianPrivateInstanceMethods)

@implementation QSIEndian (QSIEndianPrivateInstanceMethods)
@end // @implementation QSIEndian (QSIEndianPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIEndian Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIEndian Infrastructure Class Methods
//
@implementation QSIEndian (QSIEndianInfrastructureClassMethods)
@end // @implementation QSIEndian (QSIEndianInfrastructureClassMethods)

//
// QSIEndian Infrastructure Instance Methods
//
@implementation QSIEndian (QSIEndianInfrastructureInstanceMethods)
@end // @implementation QSIEndian (QSIEndianInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIEndian Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIEndian Overridden Class Methods
//
@implementation QSIEndian (QSIEndianOverriddenClassMethods)
@end // @implementation QSIEndian (QSIEndianOverriddenClassMethods)

//
// QSIEndian Overridden Instance Methods
//
@implementation QSIEndian (QSIEndianOverriddenInstanceMethods)
@end // @implementation QSIEndian (QSIEndianOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIEndian Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIEndian Public Class Methods
//
@implementation QSIEndian (QSIEndianPublicClassMethods)
@end // @implementation QSIEndian (QSIEndianPublicClassMethods)

//
// QSIEndian Public Instance Methods
//
@implementation QSIEndian (QSIEndianPublicInstanceMethods)
- (bool) getBoolFromSource : (void *) aSource
{
  uint8_t *source = (uint8_t *) aSource;

  return ((*source) != 0);
} // end -getBoolFromSource:

- (uint16_t) get16BitsFromSource : (void *) aSource
{
  [self doesNotRecognizeSelector:_cmd];

  return (0);
} // end get16BitsFromSource:

- (uint32_t) get24BitsFromSource : (void *) aSource
{
  [self doesNotRecognizeSelector:_cmd];

  return (0);
} // end -get16BitsFromSource:

- (uint32_t) get32BitsFromSource : (void *) aSource
{
  [self doesNotRecognizeSelector:_cmd];

  return (0);
} // end -get32BitsFromSource:

- (void) setBool : (void *) aDestination
       fromValue : (bool) aValue
{
  uint8_t *destination  = (uint8_t *) aDestination;

  if (aValue)
  {
    *destination = 0xff;
  }
  else
  {
    *destination = 0x00;
  }
} // end setBool:fromValue

- (void) set16Bits : (void *) aDestination
         fromValue : (uint16_t) aValue
{
  [self doesNotRecognizeSelector:_cmd];
} // end set16Bits:fromValue:

- (void) set24Bits : (void *) aDestination
         fromValue : (uint32_t) aValue
{
  [self doesNotRecognizeSelector:_cmd];
} // end set24Bits:fromValue:

- (void) set32Bits : (void *) aDestination
         fromValue : (uint32_t) aValue
{
  [self doesNotRecognizeSelector:_cmd];
} // end set32Bits:fromValue:

- (void) setString : (void *) aDestinationString
       ofMaxLength : (uint8_t) aMaxDestinationLength
        fromString : (void *) aSourceString
          ofLength : (uint8_t) aSourceLength
{
  uint8_t bytesToCopy = aMaxDestinationLength - 1;  // -1 to account for NUL

  char  *destinationString  = (char *) aDestinationString;
  char  *sourceString       = (char *) aSourceString;

  if (bytesToCopy > aSourceLength)
  {
    bytesToCopy = aSourceLength;
  }

  uint8_t index;
  for (index = 0; index < bytesToCopy; index ++)
  {
    if (*(sourceString + index) == '\0')
    {
      break;
    }

    *(destinationString + index) = *(sourceString + index);
  }

  *(destinationString + index) = '\0';
} // end -setString:ofMaxLength:fromString:ofLength:
@end // @implementation QSIEndian (QSIEndianPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIEndian Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIEndian Protected Class Methods
//
@implementation QSIEndian (QSIEndianProtectedClassMethods)
@end // @implementation QSIEndian (QSIEndianProtectedClassMethods)

//
// QSIEndian Protected Instance Methods
//
@implementation QSIEndian (QSIEndianProtectedInstanceMethods)
@end // @implementation QSIEndian (QSIEndianProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIEndian
************************************************************************************************
***********************************************************************************************/

@implementation QSIEndian
@end // @implementation QSIEndian
