//
//  QSICommsProtected.h
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIComms.h"

@interface QSIComms (QSICommsProtectedClassMethods)
+ (Class) cameraClassFromDeviceInterface : (IUnknownVTbl * *) aDeviceInterface;
+ (id) cameraUsingDeviceInterface : (IUnknownVTbl * *) aDeviceInterface;
@end // @interface QSIComms (QSICommsProtectedClassMethods)

@interface QSIComms (QSICommsProtectedInstanceMethods)
- (id) initWithDeviceInterface : (IUnknownVTbl * *) aDeviceInterface
              shortReadTimeout : (uint16_t) aShortReadTimeout
             shortWriteTimeout : (uint16_t) aShortWriteTimeout
           standardReadTimeout : (uint16_t) aStandardReadTimeout
          standardWriteTimeout : (uint16_t) aStandardWriteTimeout
           extendedReadTimeout : (uint16_t) anExtendedReadTimeout
       andExtendedWriteTimeout : (uint16_t) anExtendedWriteTimeout;

- (IUnknownVTbl * *) deviceInterface;

- (QSIStatus) performSetOfReadTimeout : (uint16_t) aReadTimeout
                      andWriteTimeout : (uint16_t) aWriteTimeout;

- (uint16_t) readTimeout;

- (void) setConnected : (bool) aIsConnected;

- (uint16_t) writeTimeout;
@end // @interface QSIComms (QSICommsProtectedInstanceMethods)
