//
//  QSICameraAdvancedDetails.h
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"

#import "QSICameraAntiBloom.h"
#import "QSICameraGain.h"
#import "QSICameraFanMode.h"
#import "QSICameraPreExposureFlush.h"
#import "QSICameraShutterPriority.h"

@interface QSICameraAdvancedDetails : QSIObject <NSCopying>
{
@private
  bool                      _antiBloomingEnabled;
  QSICameraAntiBloom        _antiBloomingIndex;

  bool                      _cameraGainEnabled;
  QSICameraGain             _cameraGainIndex;

  bool                      _fanModeEnabled;
  QSICameraFanMode          _fanModeIndex;

  bool                      _ledIndicatorDefault;
  bool                      _ledIndicatorEnabled;

  bool                      _optimizationsEnabled;
  bool                      _optimizeReadoutSpeed;

  bool                      _preExposureFlushEnabled;
  QSICameraPreExposureFlush _preExposureFlushIndex;

  bool                      _showDownloadProgressDefault;
  bool                      _showDownloadProgressEnabled;

  bool                      _shutterPriorityEnabled;
  QSICameraShutterPriority  _shutterPriorityIndex;

  bool                      _soundOnDefault;
  bool                      _soundOnEnabled;
}

@property (nonatomic, assign) bool                      _antiBloomingEnabled;
@property (nonatomic, assign) QSICameraAntiBloom        _antiBloomingIndex;

@property (nonatomic, assign) bool                      _cameraGainEnabled;
@property (nonatomic, assign) QSICameraGain             _cameraGainIndex;

@property (nonatomic, assign) bool                      _fanModeEnabled;
@property (nonatomic, assign) QSICameraFanMode          _fanModeIndex;

@property (nonatomic, assign) bool                      _ledIndicatorDefault;
@property (nonatomic, assign) bool                      _ledIndicatorEnabled;

@property (nonatomic, assign) bool                      _optimizationsEnabled;
@property (nonatomic, assign) bool                      _optimizeReadoutSpeed;

@property (nonatomic, assign) bool                      _preExposureFlushEnabled;
@property (nonatomic, assign) QSICameraPreExposureFlush _preExposureFlushIndex;

@property (nonatomic, assign) bool                      _showDownloadProgressDefault;
@property (nonatomic, assign) bool                      _showDownloadProgressEnabled;

@property (nonatomic, assign) bool                      _shutterPriorityEnabled;
@property (nonatomic, assign) QSICameraShutterPriority  _shutterPriorityIndex;

@property (nonatomic, assign) bool                      _soundOnDefault;
@property (nonatomic, assign) bool                      _soundOnEnabled;

@end // @interface QSICameraAdvancedDetails : QSIObject <NSCopying>

@interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicClassMethods)
@end // @interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicClassMethods)

@interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicInstanceMethods)
@end // @interface QSICameraAdvancedDetails (QSICameraAdvancedDetailsPublicInstanceMethods)
