//
//  QSICameraExposureParameters.h
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIObject.h"

@interface QSICameraExposureParameters : QSIObject <NSCopying>
{
@private
  uint16_t  _columnBinning;
  uint32_t  _duration;
  uint8_t   _durationUsec;
  bool      _fastReadout;
  uint16_t  _height;
  bool      _holdShutterOpen;
  bool      _openShutter;
  bool      _probeForImplemented;
  uint16_t  _repeatCount;
  uint16_t  _rowBinning;
  uint16_t  _startingColumn;
  uint16_t  _startingRow;
  bool      _strobeShutterOutput;
  bool      _useExternalTrigger;
  uint16_t  _width;
}

@property (nonatomic, assign) uint16_t  _columnBinning;
@property (nonatomic, assign) uint32_t  _duration;
@property (nonatomic, assign) uint8_t   _durationUsec;
@property (nonatomic, assign) bool      _fastReadout;
@property (nonatomic, assign) uint16_t  _height;
@property (nonatomic, assign) bool      _holdShutterOpen;
@property (nonatomic, assign) bool      _openShutter;
@property (nonatomic, assign) bool      _probeForImplemented;
@property (nonatomic, assign) uint16_t  _repeatCount;
@property (nonatomic, assign) uint16_t  _rowBinning;
@property (nonatomic, assign) uint16_t  _startingColumn;
@property (nonatomic, assign) uint16_t  _startingRow;
@property (nonatomic, assign) bool      _strobeShutterOutput;
@property (nonatomic, assign) bool      _useExternalTrigger;
@property (nonatomic, assign) uint16_t  _width;

@end // @interface QSICameraExposureParameters : QSIObject <NSCopying>

@interface QSICameraExposureParameters (QSICameraExposureParametersPublicClassMethods)
@end // @interface QSICameraExposureParameters (QSICameraExposureParametersPublicClassMethods)

@interface QSICameraExposureParameters (QSICameraExposureParametersPublicInstanceMethods)
@end // @interface QSICameraExposureParameters (QSICameraExposureParametersPublicInstanceMethods)
