//
//  QSI516Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI516CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI516Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI516Camera Private Class Methods
//
@interface QSI516Camera (QSI516CameraPrivateClassMethods)
@end // @interface QSI516Camera (QSI516CameraPrivateClassMethods)

@implementation QSI516Camera (QSI516CameraPrivateClassMethods)
@end // @implementation QSI516Camera (QSI516CameraPrivateClassMethods)

//
// QSI516Camera Private Instance Methods
//
@interface QSI516Camera (QSI516CameraPrivateInstanceMethods)
@end // @interface QSI516Camera (QSI516CameraPrivateInstanceMethods)

@implementation QSI516Camera (QSI516CameraPrivateInstanceMethods)
@end // @implementation QSI516Camera (QSI516CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI516Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI516Camera Infrastructure Class Methods
//
@implementation QSI516Camera (QSI516CameraInfrastructureClassMethods)
@end // @implementation QSI516Camera (QSI516CameraInfrastructureClassMethods)

//
// QSI516Camera Infrastructure Instance Methods
//
@implementation QSI516Camera (QSI516CameraInfrastructureInstanceMethods)
@end // @implementation QSI516Camera (QSI516CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI516Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI516Camera Overridden Class Methods
//
@implementation QSI516Camera (QSI516CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI516Camera (QSI516CameraOverriddenClassMethods)

//
// QSI516Camera Overridden Instance Methods
//
@implementation QSI516Camera (QSI516CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 2.6;
    aCCDSpecs._electronsPerADULow  = 2.6;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI516Camera (QSI516CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI516Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI516Camera Public Class Methods
//
@implementation QSI516Camera (QSI516CameraPublicClassMethods)
@end // @implementation QSI516Camera (QSI516CameraPublicClassMethods)

//
// QSI516Camera Public Instance Methods
//
@implementation QSI516Camera (QSI516CameraPublicInstanceMethods)
@end // @implementation QSI516Camera (QSI516CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI516Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI516Camera Protected Class Methods
//
@implementation QSI516Camera (QSI516CameraProtectedClassMethods)
@end // @implementation QSI516Camera (QSI516CameraProtectedClassMethods)

//
// QSI516Camera Protected Instance Methods
//
@implementation QSI516Camera (QSI516CameraProtectedInstanceMethods)
@end // @implementation QSI516Camera (QSI516CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI516Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI516Camera
@end // @implementation QSI516Camera
