//
//  QSI532Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI532CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI532Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI532Camera Private Class Methods
//
@interface QSI532Camera (QSI532CameraPrivateClassMethods)
@end // @interface QSI532Camera (QSI532CameraPrivateClassMethods)

@implementation QSI532Camera (QSI532CameraPrivateClassMethods)
@end // @implementation QSI532Camera (QSI532CameraPrivateClassMethods)

//
// QSI532Camera Private Instance Methods
//
@interface QSI532Camera (QSI532CameraPrivateInstanceMethods)
@end // @interface QSI532Camera (QSI532CameraPrivateInstanceMethods)

@implementation QSI532Camera (QSI532CameraPrivateInstanceMethods)
@end // @implementation QSI532Camera (QSI532CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI532Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI532Camera Infrastructure Class Methods
//
@implementation QSI532Camera (QSI532CameraInfrastructureClassMethods)
@end // @implementation QSI532Camera (QSI532CameraInfrastructureClassMethods)

//
// QSI532Camera Infrastructure Instance Methods
//
@implementation QSI532Camera (QSI532CameraInfrastructureInstanceMethods)
@end // @implementation QSI532Camera (QSI532CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI532Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI532Camera Overridden Class Methods
//
@implementation QSI532Camera (QSI532CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI532Camera (QSI532CameraOverriddenClassMethods)

//
// QSI532Camera Overridden Instance Methods
//
@implementation QSI532Camera (QSI532CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 1.3;
    aCCDSpecs._electronsPerADULow  = 1.3;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI532Camera (QSI532CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI532Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI532Camera Public Class Methods
//
@implementation QSI532Camera (QSI532CameraPublicClassMethods)
@end // @implementation QSI532Camera (QSI532CameraPublicClassMethods)

//
// QSI532Camera Public Instance Methods
//
@implementation QSI532Camera (QSI532CameraPublicInstanceMethods)
@end // @implementation QSI532Camera (QSI532CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI532Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI532Camera Protected Class Methods
//
@implementation QSI532Camera (QSI532CameraProtectedClassMethods)
@end // @implementation QSI532Camera (QSI532CameraProtectedClassMethods)

//
// QSI532Camera Protected Instance Methods
//
@implementation QSI532Camera (QSI532CameraProtectedInstanceMethods)
@end // @implementation QSI532Camera (QSI532CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI532Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI532Camera
@end // @implementation QSI532Camera
