//
//  QSI540Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI540CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI540Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI540Camera Private Class Methods
//
@interface QSI540Camera (QSI540CameraPrivateClassMethods)
@end // @interface QSI540Camera (QSI540CameraPrivateClassMethods)

@implementation QSI540Camera (QSI540CameraPrivateClassMethods)
@end // @implementation QSI540Camera (QSI540CameraPrivateClassMethods)

//
// QSI540Camera Private Instance Methods
//
@interface QSI540Camera (QSI540CameraPrivateInstanceMethods)
@end // @interface QSI540Camera (QSI540CameraPrivateInstanceMethods)

@implementation QSI540Camera (QSI540CameraPrivateInstanceMethods)
@end // @implementation QSI540Camera (QSI540CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI540Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI540Camera Infrastructure Class Methods
//
@implementation QSI540Camera (QSI540CameraInfrastructureClassMethods)
@end // @implementation QSI540Camera (QSI540CameraInfrastructureClassMethods)

//
// QSI540Camera Infrastructure Instance Methods
//
@implementation QSI540Camera (QSI540CameraInfrastructureInstanceMethods)
@end // @implementation QSI540Camera (QSI540CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI540Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI540Camera Overridden Class Methods
//
@implementation QSI540Camera (QSI540CameraOverriddenClassMethods)
@end // @implementation QSI540Camera (QSI540CameraOverriddenClassMethods)

//
// QSI540Camera Overridden Instance Methods
//
@implementation QSI540Camera (QSI540CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 0.8;
    aCCDSpecs._electronsPerADULow  = 1.9;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI540Camera (QSI540CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI540Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI540Camera Public Class Methods
//
@implementation QSI540Camera (QSI540CameraPublicClassMethods)
@end // @implementation QSI540Camera (QSI540CameraPublicClassMethods)

//
// QSI540Camera Public Instance Methods
//
@implementation QSI540Camera (QSI540CameraPublicInstanceMethods)
@end // @implementation QSI540Camera (QSI540CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI540Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI540Camera Protected Class Methods
//
@implementation QSI540Camera (QSI540CameraProtectedClassMethods)
@end // @implementation QSI540Camera (QSI540CameraProtectedClassMethods)

//
// QSI540Camera Protected Instance Methods
//
@implementation QSI540Camera (QSI540CameraProtectedInstanceMethods)
@end // @implementation QSI540Camera (QSI540CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI540Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI540Camera
@end // @implementation QSI540Camera
