//
//  QSI604Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI604CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI604Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI604Camera Private Class Methods
//
@interface QSI604Camera (QSI604CameraPrivateClassMethods)
@end // @interface QSI604Camera (QSI604CameraPrivateClassMethods)

@implementation QSI604Camera (QSI604CameraPrivateClassMethods)
@end // @implementation QSI604Camera (QSI604CameraPrivateClassMethods)

//
// QSI604Camera Private Instance Methods
//
@interface QSI604Camera (QSI604CameraPrivateInstanceMethods)
@end // @interface QSI604Camera (QSI604CameraPrivateInstanceMethods)

@implementation QSI604Camera (QSI604CameraPrivateInstanceMethods)
@end // @implementation QSI604Camera (QSI604CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI604Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI604Camera Infrastructure Class Methods
//
@implementation QSI604Camera (QSI604CameraInfrastructureClassMethods)
@end // @implementation QSI604Camera (QSI604CameraInfrastructureClassMethods)

//
// QSI604Camera Infrastructure Instance Methods
//
@implementation QSI604Camera (QSI604CameraInfrastructureInstanceMethods)
@end // @implementation QSI604Camera (QSI604CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI604Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI604Camera Overridden Class Methods
//
@implementation QSI604Camera (QSI604CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI604Camera (QSI604CameraOverriddenClassMethods)

//
// QSI604Camera Overridden Instance Methods
//
@implementation QSI604Camera (QSI604CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 2.6;
    aCCDSpecs._electronsPerADULow  = 2.6;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI604Camera (QSI604CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI604Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI604Camera Public Class Methods
//
@implementation QSI604Camera (QSI604CameraPublicClassMethods)
@end // @implementation QSI604Camera (QSI604CameraPublicClassMethods)

//
// QSI604Camera Public Instance Methods
//
@implementation QSI604Camera (QSI604CameraPublicInstanceMethods)
@end // @implementation QSI604Camera (QSI604CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI604Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI604Camera Protected Class Methods
//
@implementation QSI604Camera (QSI604CameraProtectedClassMethods)
@end // @implementation QSI604Camera (QSI604CameraProtectedClassMethods)

//
// QSI604Camera Protected Instance Methods
//
@implementation QSI604Camera (QSI604CameraProtectedInstanceMethods)
@end // @implementation QSI604Camera (QSI604CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI604Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI604Camera
@end // @implementation QSI604Camera
