//
//  QSI620Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI620CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI620Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI620Camera Private Class Methods
//
@interface QSI620Camera (QSI620CameraPrivateClassMethods)
@end // @interface QSI620Camera (QSI620CameraPrivateClassMethods)

@implementation QSI620Camera (QSI620CameraPrivateClassMethods)
@end // @implementation QSI620Camera (QSI620CameraPrivateClassMethods)

//
// QSI620Camera Private Instance Methods
//
@interface QSI620Camera (QSI620CameraPrivateInstanceMethods)
@end // @interface QSI620Camera (QSI620CameraPrivateInstanceMethods)

@implementation QSI620Camera (QSI620CameraPrivateInstanceMethods)
@end // @implementation QSI620Camera (QSI620CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI620Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI620Camera Infrastructure Class Methods
//
@implementation QSI620Camera (QSI620CameraInfrastructureClassMethods)
@end // @implementation QSI620Camera (QSI620CameraInfrastructureClassMethods)

//
// QSI620Camera Infrastructure Instance Methods
//
@implementation QSI620Camera (QSI620CameraInfrastructureInstanceMethods)
@end // @implementation QSI620Camera (QSI620CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI620Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI620Camera Overridden Class Methods
//
@implementation QSI620Camera (QSI620CameraOverriddenClassMethods)
@end // @implementation QSI620Camera (QSI620CameraOverriddenClassMethods)

//
// QSI620Camera Overridden Instance Methods
//
@implementation QSI620Camera (QSI620CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 0.8;
    aCCDSpecs._electronsPerADULow  = 1.9;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI620Camera (QSI620CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI620Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI620Camera Public Class Methods
//
@implementation QSI620Camera (QSI620CameraPublicClassMethods)
@end // @implementation QSI620Camera (QSI620CameraPublicClassMethods)

//
// QSI620Camera Public Instance Methods
//
@implementation QSI620Camera (QSI620CameraPublicInstanceMethods)
@end // @implementation QSI620Camera (QSI620CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI620Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI620Camera Protected Class Methods
//
@implementation QSI620Camera (QSI620CameraProtectedClassMethods)
@end // @implementation QSI620Camera (QSI620CameraProtectedClassMethods)

//
// QSI620Camera Protected Instance Methods
//
@implementation QSI620Camera (QSI620CameraProtectedInstanceMethods)
@end // @implementation QSI620Camera (QSI620CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI620Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI620Camera
@end // @implementation QSI620Camera
