//
//  QSI632Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI632CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI632Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI632Camera Private Class Methods
//
@interface QSI632Camera (QSI632CameraPrivateClassMethods)
@end // @interface QSI632Camera (QSI632CameraPrivateClassMethods)

@implementation QSI632Camera (QSI632CameraPrivateClassMethods)
@end // @implementation QSI632Camera (QSI632CameraPrivateClassMethods)

//
// QSI632Camera Private Instance Methods
//
@interface QSI632Camera (QSI632CameraPrivateInstanceMethods)
@end // @interface QSI632Camera (QSI632CameraPrivateInstanceMethods)

@implementation QSI632Camera (QSI632CameraPrivateInstanceMethods)
@end // @implementation QSI632Camera (QSI632CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI632Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI632Camera Infrastructure Class Methods
//
@implementation QSI632Camera (QSI632CameraInfrastructureClassMethods)
@end // @implementation QSI632Camera (QSI632CameraInfrastructureClassMethods)

//
// QSI632Camera Infrastructure Instance Methods
//
@implementation QSI632Camera (QSI632CameraInfrastructureInstanceMethods)
@end // @implementation QSI632Camera (QSI632CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI632Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI632Camera Overridden Class Methods
//
@implementation QSI632Camera (QSI632CameraOverriddenClassMethods)
+ (bool) ccdIsKAF
{
  return (yes);
}  // end +ccdIsKAF
@end // @implementation QSI632Camera (QSI632CameraOverriddenClassMethods)

//
// QSI632Camera Overridden Instance Methods
//
@implementation QSI632Camera (QSI632CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 1.3;
    aCCDSpecs._electronsPerADULow  = 1.3;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI632Camera (QSI632CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI632Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI632Camera Public Class Methods
//
@implementation QSI632Camera (QSI632CameraPublicClassMethods)
@end // @implementation QSI632Camera (QSI632CameraPublicClassMethods)

//
// QSI632Camera Public Instance Methods
//
@implementation QSI632Camera (QSI632CameraPublicInstanceMethods)
@end // @implementation QSI632Camera (QSI632CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI632Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI632Camera Protected Class Methods
//
@implementation QSI632Camera (QSI632CameraProtectedClassMethods)
@end // @implementation QSI632Camera (QSI632CameraProtectedClassMethods)

//
// QSI632Camera Protected Instance Methods
//
@implementation QSI632Camera (QSI632CameraProtectedInstanceMethods)
@end // @implementation QSI632Camera (QSI632CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI632Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI632Camera
@end // @implementation QSI632Camera
