//
//  QSI640Camera.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI640CameraProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSI640Camera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI640Camera Private Class Methods
//
@interface QSI640Camera (QSI640CameraPrivateClassMethods)
@end // @interface QSI640Camera (QSI640CameraPrivateClassMethods)

@implementation QSI640Camera (QSI640CameraPrivateClassMethods)
@end // @implementation QSI640Camera (QSI640CameraPrivateClassMethods)

//
// QSI640Camera Private Instance Methods
//
@interface QSI640Camera (QSI640CameraPrivateInstanceMethods)
@end // @interface QSI640Camera (QSI640CameraPrivateInstanceMethods)

@implementation QSI640Camera (QSI640CameraPrivateInstanceMethods)
@end // @implementation QSI640Camera (QSI640CameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI640Camera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI640Camera Infrastructure Class Methods
//
@implementation QSI640Camera (QSI640CameraInfrastructureClassMethods)
@end // @implementation QSI640Camera (QSI640CameraInfrastructureClassMethods)

//
// QSI640Camera Infrastructure Instance Methods
//
@implementation QSI640Camera (QSI640CameraInfrastructureInstanceMethods)
@end // @implementation QSI640Camera (QSI640CameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI640Camera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI640Camera Overridden Class Methods
//
@implementation QSI640Camera (QSI640CameraOverriddenClassMethods)
@end // @implementation QSI640Camera (QSI640CameraOverriddenClassMethods)

//
// QSI640Camera Overridden Instance Methods
//
@implementation QSI640Camera (QSI640CameraOverriddenInstanceMethods)
- (QSIStatus) getCCDSpecs : (QSICameraCCDSpecs *) aCCDSpecs
{
  QSIStatus status  = [super getCCDSpecs:aCCDSpecs];

  if (status == QSISuccess)
  {
    aCCDSpecs._electronsPerADUHigh = 0.8;
    aCCDSpecs._electronsPerADULow  = 1.9;
  }

  return (status);
} // end -getCCDSpecs:
@end // @implementation QSI640Camera (QSI640CameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI640Camera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI640Camera Public Class Methods
//
@implementation QSI640Camera (QSI640CameraPublicClassMethods)
@end // @implementation QSI640Camera (QSI640CameraPublicClassMethods)

//
// QSI640Camera Public Instance Methods
//
@implementation QSI640Camera (QSI640CameraPublicInstanceMethods)
@end // @implementation QSI640Camera (QSI640CameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI640Camera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI640Camera Protected Class Methods
//
@implementation QSI640Camera (QSI640CameraProtectedClassMethods)
@end // @implementation QSI640Camera (QSI640CameraProtectedClassMethods)

//
// QSI640Camera Protected Instance Methods
//
@implementation QSI640Camera (QSI640CameraProtectedInstanceMethods)
@end // @implementation QSI640Camera (QSI640CameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI640Camera
************************************************************************************************
***********************************************************************************************/

@implementation QSI640Camera
@end // @implementation QSI640Camera
