//
//  QSICameraDefaultsProtected.h
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraDefaults.h"

#define QSICameraAntiBloomDefaultKey        @"AntiBloomDefault"
#define QSICameraAntiBloomDefault           @"0"

#define QSICameraCoolerSetPointDefaultKey   @"CoolerSetPointDefault"
#define QSICameraCoolerSetPointDefault      @"0.0"

#define QSICameraCoolerStateDefaultKey      @"CoolerStateDefault"
#define QSICameraCoolerStateDefault         @"1"

#define QSICameraFanModeDefaultKey          @"FanModeDefault"
#define QSICameraFanModeDefault             @"1"

#define QSICameraGainDefaultKey             @"GainDefault"
#define QSICameraGainDefault                @"0"

#define QSICameraLEDAlertDefaultKey         @"LEDAlertDefault"
#define QSICameraLEDAlertDefault            @"1"

#define QSICameraPreExposureFlushDefaultKey @"PreExposureFlushDefault"
#define QSICameraPreExposureFlushDefault    @"2"

#define QSICameraReadoutSpeedDefaultKey     @"ReadoutSpeedDefault"
#define QSICameraReadoutSpeedDefault        @"0"

#define QSICameraShutterPriorityDefaultKey  @"ShutterPriorityDefault"
#define QSICameraShutterPriorityDefault     @"0"

#define QSICameraSoundAlertDefaultKey       @"SoundAlertDefault"
#define QSICameraSoundAlertDefault          @"1"

@interface QSICameraDefaults (QSICameraDefaultsProtectedClassMethods)
+ (NSDictionary *) defaultDictionary;
@end // @interface QSICameraDefaults (QSICameraDefaultsProtectedClassMethods)

@interface QSICameraDefaults (QSICameraDefaultsProtectedInstanceMethods)
- (void) setObject : (id) anObject
            forKey : (NSString *) aKey;
@end // @interface QSICameraDefaults (QSICameraDefaultsProtectedInstanceMethods)
