//
//  QSICameraDetails.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraDetailsProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraDetails Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDetails Infrastructure Class Methods
//
@implementation QSICameraDetails (QSICameraDetailsInfrastructureClassMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsInfrastructureClassMethods)

//
// QSICameraDetails Infrastructure Instance Methods
//
@implementation QSICameraDetails (QSICameraDetailsInfrastructureInstanceMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraDetails Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDetails Overridden Class Methods
//
@implementation QSICameraDetails (QSICameraDetailsOverriddenClassMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsOverriddenClassMethods)

//
// QSICameraDetails Overridden Instance Methods
//
@implementation QSICameraDetails (QSICameraDetailsOverriddenInstanceMethods)
- (id) init
{
  self = [super init];
  if (self != nil)
  {
    _arrayColumns              = 0;
    _arrayRows                 = 0;
    _hasCamera                 = no;
    _hasFilterWheel            = no;
    _hasRelays                 = no;
    _hasShutter                = no;
    _hasTemperatureRegulator   = no;
    _maxHorizontalBinning      = 1;
    _maxVerticalBinning        = 1;
    _modelName                 = nil;
    _modelNumber               = nil;
    _numberOfFilters           = 0;
    _numberOfRowsPerBlock      = 0;
    _perBlockControl           = no;
    _powerOfTwoBinning         = no;
    _serialNumber              = nil;
    _supportsAsymmetricBinning = no;
    _pixelWidth                = 0;
    _pixelHeight               = 0;
  }
  
  return (self);
} // end -init
@end // @implementation QSICameraDetails (QSICameraDetailsOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraDetails Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDetails Private Class Methods
//
@interface QSICameraDetails (QSICameraDetailsPrivateClassMethods)
@end // @interface QSICameraDetails (QSICameraDetailsPrivateClassMethods)

@implementation QSICameraDetails (QSICameraDetailsPrivateClassMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsPrivateClassMethods)

//
// QSICameraDetails Private Instance Methods
//
@interface QSICameraDetails (QSICameraDetailsPrivateInstanceMethods)
@end // @interface QSICameraDetails (QSICameraDetailsPrivateInstanceMethods)

@implementation QSICameraDetails (QSICameraDetailsPrivateInstanceMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraDetails Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDetails Protected Class Methods
//
@implementation QSICameraDetails (QSICameraDetailsProtectedClassMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsProtectedClassMethods)

//
// QSICameraDetails Protected Instance Methods
//
@implementation QSICameraDetails (QSICameraDetailsProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraDetails *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _arrayColumns              = anInstance._arrayColumns;
    _arrayRows                 = anInstance._arrayRows;
    _hasCamera                 = anInstance._hasCamera;
    _hasFilterWheel            = anInstance._hasFilterWheel;
    _hasRelays                 = anInstance._hasRelays;
    _hasShutter                = anInstance._hasShutter;
    _hasTemperatureRegulator   = anInstance._hasTemperatureRegulator;
    _maxHorizontalBinning      = anInstance._maxHorizontalBinning;
    _maxVerticalBinning        = anInstance._maxVerticalBinning;
    _modelName                 = [anInstance._modelName retain];
    _modelNumber               = [anInstance._modelNumber retain];
    _numberOfFilters           = anInstance._numberOfFilters;
    _numberOfRowsPerBlock      = anInstance._numberOfRowsPerBlock;
    _perBlockControl           = anInstance._perBlockControl;
    _pixelHeight               = anInstance._pixelHeight;
    _pixelWidth                = anInstance._pixelWidth;
    _powerOfTwoBinning         = anInstance._powerOfTwoBinning;
    _serialNumber              = [anInstance._serialNumber retain];
    _supportsAsymmetricBinning = anInstance._supportsAsymmetricBinning;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraDetails (QSICameraDetailsProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraDetails Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDetails Public Class Methods
//
@implementation QSICameraDetails (QSICameraDetailsPublicClassMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsPublicClassMethods)

//
// QSICameraDetails Public Instance Methods
//
@implementation QSICameraDetails (QSICameraDetailsPublicInstanceMethods)
@end // @implementation QSICameraDetails (QSICameraDetailsPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraDetails
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraDetails

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _arrayColumns;
@synthesize _arrayRows;
@synthesize _hasCamera;
@synthesize _hasFilterWheel;
@synthesize _hasRelays;
@synthesize _hasShutter;
@synthesize _hasTemperatureRegulator;
@synthesize _maxHorizontalBinning;
@synthesize _maxVerticalBinning;
@synthesize _modelName;
@synthesize _modelNumber;
@synthesize _numberOfFilters;
@synthesize _numberOfRowsPerBlock;
@synthesize _perBlockControl;
@synthesize _pixelHeight;
@synthesize _pixelWidth;
@synthesize _powerOfTwoBinning;
@synthesize _serialNumber;
@synthesize _supportsAsymmetricBinning;

@end // @implementation QSICameraDetails
