//
//  QSICameraDeviceState.m
//  QSICamera
//
//  Copyright (c) 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSICameraDeviceStateProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSICameraDeviceState Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDeviceState Infrastructure Class Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStateInfrastructureClassMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStateInfrastructureClassMethods)

//
// QSICameraDeviceState Infrastructure Instance Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStateInfrastructureInstanceMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStateInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraDeviceState Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDeviceState Overridden Class Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStateOverriddenClassMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStateOverriddenClassMethods)

//
// QSICameraDeviceState Overridden Instance Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStateOverriddenInstanceMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStateOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraDeviceState Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDeviceState Private Class Methods
//
@interface QSICameraDeviceState (QSICameraDeviceStatePrivateClassMethods)
@end // @interface QSICameraDeviceState (QSICameraDeviceStatePrivateClassMethods)

@implementation QSICameraDeviceState (QSICameraDeviceStatePrivateClassMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStatePrivateClassMethods)

//
// QSICameraDeviceState Private Instance Methods
//
@interface QSICameraDeviceState (QSICameraDeviceStatePrivateInstanceMethods)
@end // @interface QSICameraDeviceState (QSICameraDeviceStatePrivateInstanceMethods)

@implementation QSICameraDeviceState (QSICameraDeviceStatePrivateInstanceMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStatePrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSICameraDeviceState Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDeviceState Protected Class Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStateProtectedClassMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStateProtectedClassMethods)

//
// QSICameraDeviceState Protected Instance Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStateProtectedInstanceMethods)
- (id) initUsingInstance : (QSICameraDeviceState *) anInstance
{
  self = [super init];
  if (self != nil)
  {
    _cameraState  = anInstance._cameraState;
    _filterState  = anInstance._filterState;
    _shutterOpen  = anInstance._shutterOpen;
  }

  return (self);
} // end -initUsingInstance:
@end // @implementation QSICameraDeviceState (QSICameraDeviceStateProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSICameraDeviceState Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSICameraDeviceState Public Class Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStatePublicClassMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStatePublicClassMethods)

//
// QSICameraDeviceState Public Instance Methods
//
@implementation QSICameraDeviceState (QSICameraDeviceStatePublicInstanceMethods)
@end // @implementation QSICameraDeviceState (QSICameraDeviceStatePublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSICameraDeviceState
************************************************************************************************
***********************************************************************************************/

@implementation QSICameraDeviceState

- (id) copyWithZone : (NSZone *) aZone
{
  return ([[[self class] allocWithZone:aZone] initUsingInstance:self]);
} // end -copyWithZone:

@synthesize _cameraState;
@synthesize _filterState;
@synthesize _shutterOpen;

@end // @implementation QSICameraDeviceState
