//
//  QSI583cTestCamera.m
//  QSICamera
//
//  Copyright (c) 2010, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSI583cTestCameraProtected.h"

#import "QSICommand.h"

/***********************************************************************************************
************************************************************************************************
* QSI583cTestCamera Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583cTestCamera Private Class Methods
//
@interface QSI583cTestCamera (QSI583cTestCameraPrivateClassMethods)
@end // @interface QSI583cTestCamera (QSI583cTestCameraPrivateClassMethods)

@implementation QSI583cTestCamera (QSI583cTestCameraPrivateClassMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraPrivateClassMethods)

//
// QSI583cTestCamera Private Instance Methods
//
@interface QSI583cTestCamera (QSI583cTestCameraPrivateInstanceMethods)
@end // @interface QSI583cTestCamera (QSI583cTestCameraPrivateInstanceMethods)

@implementation QSI583cTestCamera (QSI583cTestCameraPrivateInstanceMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI583cTestCamera Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583cTestCamera Infrastructure Class Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraInfrastructureClassMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraInfrastructureClassMethods)

//
// QSI583cTestCamera Infrastructure Instance Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraInfrastructureInstanceMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI583cTestCamera Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583cTestCamera Overridden Class Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraOverriddenClassMethods)
+ (bool) colorCamera
{
  return (yes);
} // end +colorCamera
@end // @implementation QSI583cTestCamera (QSI583cTestCameraOverriddenClassMethods)

//
// QSI583cTestCamera Overridden Instance Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraOverriddenInstanceMethods)
- (QSIStatus) getDetails : (QSICameraDetails *) aDetails
{
  QSIStatus status  = [super getDetails:aDetails];
  
  if (status == QSISuccess)
  {
    aDetails._modelNumber  = @"583cTest";
    aDetails._serialNumber = @"123456c";
  }
  
  return (status);
} // end -getDetails:
@end // @implementation QSI583cTestCamera (QSI583cTestCameraOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSI583cTestCamera Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583cTestCamera Public Class Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraPublicClassMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraPublicClassMethods)

//
// QSI583cTestCamera Public Instance Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraPublicInstanceMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSI583cTestCamera Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSI583cTestCamera Protected Class Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraProtectedClassMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraProtectedClassMethods)

//
// QSI583cTestCamera Protected Instance Methods
//
@implementation QSI583cTestCamera (QSI583cTestCameraProtectedInstanceMethods)
@end // @implementation QSI583cTestCamera (QSI583cTestCameraProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSI583cTestCamera
************************************************************************************************
***********************************************************************************************/

@implementation QSI583cTestCamera
@end // @implementation QSI583cTestCamera
