//
//  QSIFilter.m
//  QSICamera
//
//  Copyright (c) 2011, 2012, Joe Shimkus
//   All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//  	• 	Redistributions of source code must retain the above copyright
//      	notice, this list of conditions and the following disclaimer.
//  	• 	Redistributions in binary form must reproduce the above copyright
//        notice, this list of conditions and the following disclaimer in the
//        documentation and/or other materials provided with the distribution.
//  	• 	The name of Joe Shimkus may not be used to endorse or promote
//        products derived from this software without specific prior written
//        permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
//  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
//  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
//  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
//  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
//  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
//  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
//  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
//  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
//  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "QSIFilterProtected.h"

/***********************************************************************************************
************************************************************************************************
* QSIFilter Private Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIFilter Private Class Methods
//
@interface QSIFilter (QSIFilterPrivateClassMethods)
@end // @interface QSIFilter (QSIFilterPrivateClassMethods)

@implementation QSIFilter (QSIFilterPrivateClassMethods)
@end // @implementation QSIFilter (QSIFilterPrivateClassMethods)

//
// QSIFilter Private Instance Methods
//
@interface QSIFilter (QSIFilterPrivateInstanceMethods)
@end // @interface QSIFilter (QSIFilterPrivateInstanceMethods)

@implementation QSIFilter (QSIFilterPrivateInstanceMethods)
@end // @implementation QSIFilter (QSIFilterPrivateInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIFilter Infrastructure Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIFilter Infrastructure Class Methods
//
@implementation QSIFilter (QSIFilterInfrastructureClassMethods)
@end // @implementation QSIFilter (QSIFilterInfrastructureClassMethods)

//
// QSIFilter Infrastructure Instance Methods
//
@implementation QSIFilter (QSIFilterInfrastructureInstanceMethods)
- (void) dealloc
{
  [_name release];

  [super dealloc];
} // end -dealloc

- (id) init
{
  return ([self initWithName:@"unassigned name"]);
} // end -init
@end // @implementation QSIFilter (QSIFilterInfrastructureInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIFilter Overridden Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIFilter Overridden Class Methods
//
@implementation QSIFilter (QSIFilterOverriddenClassMethods)
@end // @implementation QSIFilter (QSIFilterOverriddenClassMethods)

//
// QSIFilter Overridden Instance Methods
//
@implementation QSIFilter (QSIFilterOverriddenInstanceMethods)
@end // @implementation QSIFilter (QSIFilterOverriddenInstanceMethods)


/***********************************************************************************************
************************************************************************************************
* QSIFilter Public Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIFilter Public Class Methods
//
@implementation QSIFilter (QSIFilterPublicClassMethods)
@end // @implementation QSIFilter (QSIFilterPublicClassMethods)

//
// QSIFilter Public Instance Methods
//
@implementation QSIFilter (QSIFilterPublicInstanceMethods)
- (id) initWithName : (NSString *) aName
{
  return ([self initWithName:aName andFocusOffset:0]);
} // end -initWithName:

- (id) initWithName : (NSString *) aName
     andFocusOffset : (int32_t) aFocusOffset
{
  return ([self initWithName:aName
                 focusOffset:aFocusOffset
                     andTrim:0]);
} // end -initWithName:andFocusOffset:

- (id) initWithName : (NSString *) aName
        focusOffset : (int32_t) aFocusOffset
            andTrim : (int16_t) aTrim
{
  self = [super init];
  if (self != nil)
  {
    _focusOffset  = aFocusOffset;
    _name         = [aName retain];
    _trim         = aTrim;
  }

  return (self);
} // end -initWithName:focusOffset:andTrim

- (int32_t) focusOffset
{
  return (_focusOffset);
} // end -focusOffset

- (NSString *) name
{
  return (_name);
} // end -name

- (void) setFocusOffset : (int32_t) aFocusOffset
{
  _focusOffset = aFocusOffset;
} // end -setFocusOffset:

- (void) setName : (NSString *) aName
{
  [_name autorelease];

  _name = [aName retain];
} // end -setName:

- (void) setTrim : (int16_t) aTrim
{
  _trim = aTrim;
} // end -setTrim:

- (int16_t) trim
{
  return (_trim);
} // end -trim

@end // @implementation QSIFilter (QSIFilterPublicInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* QSIFilter Protected Methods
************************************************************************************************
***********************************************************************************************/

//
// QSIFilter Protected Class Methods
//
@implementation QSIFilter (QSIFilterProtectedClassMethods)
@end // @implementation QSIFilter (QSIFilterProtectedClassMethods)

//
// QSIFilter Protected Instance Methods
//
@implementation QSIFilter (QSIFilterProtectedInstanceMethods)
@end // @implementation QSIFilter (QSIFilterProtectedInstanceMethods)

/***********************************************************************************************
************************************************************************************************
* The QSIFilter
************************************************************************************************
***********************************************************************************************/

@implementation QSIFilter
@end // @implementation QSIFilter
